using System;

namespace Server.Items
{
    public abstract class BaseSilkShoes : BaseClothing
    {
        public BaseSilkShoes(int itemID): this(itemID, 0)
        {
        }

        public BaseSilkShoes(int itemID, int hue): base(itemID, Layer.Shoes, hue)
        {
        }

        public BaseSilkShoes(Serial serial): base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)2); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 2: break; // empty, resource removed
                case 1:
                    {
                        m_Resource = (CraftResource)reader.ReadInt();
                        break;
                    }
                case 0:
                    {
                        m_Resource = DefaultResource;
                        break;
                    }
            }
        }
    }

    [Flipable(0x2307, 0x2308)]
    public class SilkBoots : BaseSilkShoes
    {
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 2; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 3; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 30; } }
        public override int InitMaxHits { get { return 45; } }

        [Constructable]
        public SilkBoots(): this(0)
        {
        }

        [Constructable]
        public SilkBoots(int hue): base(0x2307, hue)
        {
            Weight = 3.0;
            Name = "Silk Boots";
        }

        public SilkBoots(Serial serial): base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    [Flipable(0x2797, 0x27E2)]
    public class SilkNinjaTabi : BaseSilkShoes
    {
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 2; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 3; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 30; } }
        public override int InitMaxHits { get { return 45; } }

        [Constructable]
        public SilkNinjaTabi(): this(0)
        {
        }

        [Constructable]
        public SilkNinjaTabi(int hue): base(0x2797, hue)
        {
            Weight = 2.0;
            Name = "Silk Ninja Tabi";
        }

        public SilkNinjaTabi(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    [Flipable(0x2796, 0x27E1)]
    public class SilkSamuraiTabi : BaseSilkShoes
    {
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 2; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 3; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 30; } }
        public override int InitMaxHits { get { return 45; } }

        [Constructable]
        public SilkSamuraiTabi(): this(0)
        {
        }

        [Constructable]
        public SilkSamuraiTabi(int hue): base(0x2796, hue)
        {
            Weight = 2.0;
            Name = "Silk Samurai Tabi";
        }

        public SilkSamuraiTabi(Serial serial): base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}